package com.hp.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.ht.bo.ApplicationUtil;
import com.ht.bo.ProductBean;
import com.ht.util.ConnectionUtil;
import com.ht.utility.CommonUtility;
import com.ht.vo.Cart;
import com.ht.vo.Product;

/**
 * Servlet implementation class Main
 */
@WebServlet("/Main")
public class Main extends HttpServlet {
	private static final long serialVersionUID = 1L;
       
    /**
     * @see HttpServlet#HttpServlet()
     */
    public Main() {
        super();
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		ApplicationUtil util = new ApplicationUtil();
		HttpSession session = util.createSession(request);
		String userName = request.getParameter("userName");
		String catalog = request.getParameter("catalog"); 
		 session.setAttribute("userName", userName);
		
		ProductBean bean = (ProductBean) request.getSession().getAttribute("product");
		if(catalog!=null){
			ArrayList<Product> prodList =  ConnectionUtil.populateOrderList(catalog);
			session.setAttribute("prodList", prodList); 
		}
		
		Cart mycart = ApplicationUtil.populateCart(userName, catalog);
		session.setAttribute("mycart", mycart);
		session.setAttribute("catalog", catalog);
		session.setAttribute("totalItems", mycart.getProdList().size());
		System.out.println("--------------" + catalog + mycart);
		// CommonUtility.sendtoAnotherPage(request, response, "/workspace.jsp");
		 CommonUtility.sendtoAnotherPage(request, response, "/faces/order.xhtml");
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
	}

}
